//+------------------------------------------------------------------+
//|                                              Volatility Stop.mq4 |
//|                                       Copyright  2006, Akuma99. |
//|                                      http://akuma99.blogspot.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Akuma99."
#property link      "http://akuma99.blogspot.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Blue
//---- input parameters
extern bool    short;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,159);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexEmptyValue(0,0.0);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,159);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexEmptyValue(1,0.0);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
   int   limit = Bars-counted_bars;
   int   i;
   
   for (i=limit; i>=0; i--) {
   
      double r = findRange(i);
      
      Print (r);
      
      if (short == true) {
      
         ExtMapBuffer1[i] = MathMin(High[i]+r, ExtMapBuffer1[i+1]);
         
      } else if (short == false) {
         
         ExtMapBuffer2[i] = MathMax(Low[i]-r,ExtMapBuffer2[i+1]);
         
      }
      
      Print (ExtMapBuffer2[i]);
   
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+

double findRange(int i) {

   double rng;
   
   for (int j=24; j>=0; j--) {
      rng += (High[i+j]-Low[i+j]);
   }

   rng = (rng/24)*1.5;

   return(rng);

}